# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 1
# Experiment: PMxPM, Run: 4
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR1_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR1(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not my_history:  # Round 1: Start with Cooperate
        return "C"
    
    # Analyze opponent's code for deterministic patterns
    always_c = "return 'C'" in opponent_program_code or "return 'c'" in opponent_program_code
    always_d = "return 'D'" in opponent_program_code or "return 'd'" in opponent_program_code
    is_random = "random" in opponent_program_code
    
    # Handle deterministic opponents
    if always_d:
        return "D"
    if always_c:
        # Exploit always-cooperate by defecting occasionally (every 3rd round)
        if len(my_history) % 3 == 0:
            return "D"
        else:
            return "C"
    
    # Default to Tit-for-Tat with forgiveness (10% chance to forgive)
    last_opp_move = opp_history[-1]
    if last_opp_move == "D" and random.random() < 0.1:
        return "C"
    
    # Near the end (last 3 rounds), defect more if opponent has been exploitable
    if len(my_history) >= 7 and sum(1 for m in opp_history if m == "C") / len(opp_history) > 0.7:
        return "D"
    
    return last_opp_move  # Tit-for-Tat